/**
* \file: CarPlayAudioCodec.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPLay
*
* \author: Sudha Kuppusamy/ sudha.kuppusamy@in.bosch.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AUDIO_CODEC
#define CARPLAY_AUDIO_CODEC

#include <gst/gst.h>
#include <map>
#include <string.h>
#include <adit_logging.h>
#include <carplay_plugin.h>

#include "APSAudioConverter.h"

//  Internals
//===========================================================================================================================

struct GstreamerPipeline
{
    GstElement* appsink;
    GstElement* appsrc;
    GstElement* codec;
    GMainLoop* loop;
    pthread_t mainLoopThreadID;
    GstBus* bus;
};

typedef struct AudioConverterPrivate* AudioConverterPrivateRef;
struct AudioConverterPrivate
{
    uint32_t sourceFormatID;
    uint32_t destFormatID;
    uint32_t sampleRate;
    uint32_t channels;
    uint32_t framesPerPacket;
    uint32_t bitsPerChannel;
    void*    nativeCodecRef;
    uint8_t* pcmBuffer;
    uint32_t pcmBufferPos;

    struct   GstreamerPipeline* pipeline;
    bool     pipelineCreated;
};

enum AudioCodecs
{
    AAC_LC_Decoder  = 0,
    OPUS_Decoder    = 1,
    OPUS_Encoder    = 2
};

typedef enum AudioCodecs AudioCodec;

OSStatus audioConverterCreateGstPipeline(AudioConverterPrivateRef codecFormat, AudioCodec AudioDecoderEncoder);
void audioConverterDestroyGstPipeline(AudioConverterPrivateRef codecFormat);
OSStatus _AudioConverterConvertAudioData(AudioConverterPrivateRef inConverter, void* inData, uint32_t inDataSize, AudioBufferList* outOutputData);
OSStatus _AudioConverterSendEOS(AudioConverterPrivateRef inConverter);

#endif /* CARPLAY_AUDIO_CODEC */
